clear all 
set matsize 5000
set maxvar 32000
set more off
pause on


*Enter the folder where you have placed the replication files and data
global dir "C:REPLICATION\Output"
cd "${dir}"
log using CNR_IMFER_replicate, replace

capture rmdir "graphs"
capture mkdir "graphs"

use exchange_long_weekly
keep if country=="fr"
gen eurx = 1/usdx
keep date eurx
joinby date using exchange_long_weekly
replace eurx = usdx*eurx
save exchange_long_weekly_weuro, replace
clear

* Following lines generate histo_lv_bilat_prepost.pdf, which appears as Figure 1 in our paper.

foreach base in "lv" {
	clear
	use "cnr_latvia_weekly_bilat_nocats_wprice.dta"
	keep if store=="Zara"
	keep if country_i=="`base'" | country_j=="`base'"
	drop qij1 qij2 qij3 usdper*
	gen lveuro = er_ij if country_i=="fr" & country_j=="lv"
	bys date: egen latcorrect = mean(lveuro)
	replace qij = qij - ln(latcorrect) if country_i=="lv" & date>=2808
	replace qij = qij + ln(latcorrect) if country_j=="lv" & date>=2808
	drop latcorrect lveuro
	gen year=floor(date/52)+1960
	gen week=date-52*(year-1960)+1
	gen yearlab = year+(week-1)/52

	*****************************
	count
	drop if abs(qij)>0.4
	*****************************
	gen counter = 1
	bys country_i country_j store: egen wt = sum(counter)
	gen fwt = round(10000000/wt)
	drop wt counter maxgap
	save tmp_base, replace

	foreach cty in "de" "fr" "it" "us" {
		clear
		use tmp_base
		if "`base'"<"`cty'" {
			keep if country_i=="`base'" & country_j=="`cty'"
			replace country_i="`cty'"
			replace country_j="`base'"
			replace qij = -qij
		}
		if "`cty'"<"`base'" {
			keep if country_i=="`cty'" & country_j=="`base'"
		}
		if "`cty'"=="`base'" {
			keep if _n==3
		}
		save tmp, replace
		clear
		use "cnr_covars.dta"
		replace ctylab = "United States" if ctylab=="USA"
		keep country ctylab
		rename country country_i
		joinby country_i using tmp
		save tmp, replace
		quietly: sum qij [fw=fwt]
		local obsno = r(N)
		local ctylabel = ctylab[1]
		
		if `obsno'>0 {
			quietly: sum qij if year<2014 [fw=fwt]
			local qij_mean1 = r(mean)
			quietly: sum qij if year==2014 [fw=fwt]
			local qij_mean2 = r(mean)
			local ctyname = ctylab[1]
			hist qij if year<2014 [fw=fwt], percent width(0.025) color(black) subtitle("Latvia Pegged") xlabel(-0.4(0.2)0.4) ylabel(0(25)100) xtitle("") ytitle("") graphregion(color(white))
			graph save "graphs\histo_`base'_`cty'_pre2014", replace
			hist qij if year==2014 [fw=fwt], percent width(0.025) color(black) subtitle("Latvia in Euro") xlabel(-0.4(0.2)0.4) ylabel(0(25)100) xtitle("") ytitle("") graphregion(color(white))
			graph save "graphs\histo_`base'_`cty'_2014", replace
			graph combine "graphs\histo_`base'_`cty'_pre2014.gph" "graphs\histo_`base'_`cty'_2014.gph", graphregion(color(white)) rows(1) subtitle(`ctylabel', size(large))
			graph save "graphs\histo_`base'_`cty'_both	", replace
		}			
	}
}

cd "graphs"
graph combine "histo_lv_fr_both" "histo_lv_de_both" "histo_lv_it_both" "histo_lv_us_both", graphregion(color(white)) rows(2)
graph save "histo_lv_all1", replace
graph export "histo_lv_bilat_prepost.pdf", as(pdf) replace
cd "${dir}"
save latvia_ts1, replace

clear

* Following lines generate lopshareline_zara.pdf, which appears as Figure 3, and medandmeanabsline_zara.pdf, which appears as Figure 4, in our paper.

cd "${dir}"
use "cnr_latvia_weekly_bilat_nocats_wprice.dta"
drop qij1 qij2 qij3 usdper*
gen lveuro = er_ij if country_i=="fr" & country_j=="lv"
bys date: egen latcorrect = mean(lveuro)
replace qij = qij - ln(latcorrect) if country_i=="lv" & date>=2808
replace qij = qij + ln(latcorrect) if country_j=="lv" & date>=2808
drop latcorrect lveuro
gen pair = country_i+country_j
gen keeper = 1 if inlist(pair,"dklv","delv","filv","frlv","ielv","itlv")
replace keeper = 1 if inlist(pair,"lvnl","lvus","defr","dedk","delt","ltlv")
keep if keeper==1
drop keeper
drop if abs(qij)>0.40
gen abs_qij = abs(qij)
gen lopnum = 1 if abs_qij<=0.01
bys store date pair: egen qij_absmean = mean(abs_qij)
quietly: bys store date pair: sum abs_qij, d
bys store date pair: egen qij_absmedian = median(abs_qij)
bys store date pair: egen qij_median = median(qij)
bys store date pair: egen qij_mean = mean(qij)
bys store date pair: egen qij_count = count(qij)
bys store date pair: egen qij_lopcount = count(lopnum)
keep store date qij_absmedian qij_absmean  qij_mean  qij_median  qij_lopcount pair er_ij qij_count
duplicates drop
sort store pair date
gen forlevplot =1 if abs(ln(qij_count/qij_count[_n-1]))<0.25 & pair==pair[_n-1]
gen qij_lopshare = 100*qij_lopcount/qij_count
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen yearlab = year+(week-1)/52
levelsof pair, local(pairs)

line qij_lopshare yearlab if pair=="frlv" & store=="Zara", lwidth(medthick) xlabel(2012(1)2015) ylabel(0(25)100) title("France") graphregion(color(white)) xtitle("") ytitle("") xline(2014, lcolor(red) lpattern(dash)) 
graph save "graphs\lopshare_zara_frlv", replace

line qij_lopshare yearlab if pair=="delv" & store=="Zara", lwidth(medthick) xlabel(2012(1)2015) ylabel(0(25)100) title("Germany") graphregion(color(white)) xtitle("") ytitle("") xline(2014, lcolor(red) lpattern(dash)) 
graph save "graphs\lopshare_zara_delv", replace

line qij_lopshare yearlab if pair=="itlv" & store=="Zara", lwidth(medthick) xlabel(2012(1)2015) ylabel(0(25)100) title("Italy") graphregion(color(white)) xtitle("") ytitle("") xline(2014, lcolor(red) lpattern(dash)) 
graph save "graphs\lopshare_zara_itlv", replace

line qij_lopshare yearlab if pair=="lvus" & store=="Zara" , lwidth(medthick) xlabel(2012(1)2015) ylabel(0(25)100) title("United States") graphregion(color(white)) xtitle("") ytitle("") xline(2014, lcolor(red) lpattern(dash)) 
graph save "graphs\lopshare_zara_lvus", replace

line qij_absmedian yearlab if forlevplot ==1 & pair=="frlv" & store=="Zara" & qij_absmedian<0.2, lwidth(medthick) legend(label(1 "Median")) lpattern(solid) lcolor(black) xlabel(2012(1)2015) ylabel(0(0.1)0.3) title("France") graphregion(color(white)) xtitle("") ytitle("") xline(2014, lcolor(red) lpattern(dash)) || line qij_absmean yearlab if forlevplot ==1 & pair=="frlv" & store=="Zara" & qij_absmean<0.2, lwidth(medthick) legend(label(2 "Mean") rows(1)) lpattern(dash) lcolor(blue) 
graph save "graphs\medandmeanabsline_zara_frlv", replace

line qij_absmedian yearlab if forlevplot ==1 & pair=="delv" & store=="Zara" & qij_absmedian<0.2, lwidth(medthick) legend(label(1 "Median")) lpattern(solid) lcolor(black) xlabel(2012(1)2015) ylabel(0(0.1)0.3) title("Germany") graphregion(color(white)) xtitle("") ytitle("") xline(2014, lcolor(red) lpattern(dash)) ||	line qij_absmean yearlab if forlevplot ==1 & pair=="delv" & store=="Zara" & qij_absmean<0.2, lwidth(medthick) legend(label(2 "Mean") rows(1)) lpattern(dash) lcolor(blue) 
graph save "graphs\medandmeanabsline_zara_delv", replace

line qij_absmedian yearlab if forlevplot ==1 & pair=="itlv" & store=="Zara" & qij_absmedian<0.2, lwidth(medthick) legend(label(1 "Median")) lpattern(solid) lcolor(black) xlabel(2012(1)2015) ylabel(0(0.1)0.3) title("Italy") graphregion(color(white)) xtitle("") ytitle("") xline(2014, lcolor(red) lpattern(dash)) || line qij_absmean yearlab if forlevplot ==1 & pair=="itlv" & store=="Zara" & qij_absmean<0.2, lwidth(medthick) legend(label(2 "Mean") rows(1)) lpattern(dash) lcolor(blue) 
graph save "graphs\medandmeanabsline_zara_itlv", replace

line qij_absmedian yearlab if forlevplot ==1 & pair=="lvus" & store=="Zara" & qij_absmedian<0.2, lwidth(medthick) legend(label(1 "Median")) lpattern(solid) lcolor(black) xlabel(2012(1)2015) ylabel(0(0.1)0.3) title("United States") graphregion(color(white)) xtitle("") ytitle("") xline(2014, lcolor(red) lpattern(dash)) || line qij_absmean yearlab if forlevplot ==1 & pair=="lvus" & store=="Zara" & qij_absmean<0.2, lwidth(medthick) legend(label(2 "Mean") rows(1)) lpattern(dash) lcolor(blue) 
graph save "graphs\medandmeanabsline_zara_lvus", replace

cd "graphs"

grc1leg "medandmeanabsline_zara_frlv.gph" "medandmeanabsline_zara_delv.gph" "medandmeanabsline_zara_itlv.gph" "medandmeanabsline_zara_lvus.gph", graphregion(color(white)) rows(2)
graph export "medandmeanabsline_zara.pdf", as(pdf) replace
graph combine "lopshare_zara_frlv.gph" "lopshare_zara_delv.gph" "lopshare_zara_itlv.gph" "lopshare_zara_lvus.gph", graphregion(color(white)) rows(2)
graph export "lopshareline_zara.pdf", as(pdf) replace
cd "${dir}"

save latvia_ts2, replace
clear

cd "${dir}"

* In following lines, "sum monthcount" command generates the value for "# of Products" rows in Table 1 of the paper, separated by country and by pre-2014 and post-2014.
* In following lines, "sum price_eur" command generates the value for the "Prices (in euros)" rows in Table 1 of the paper, separated by country and percentile and pre-2014 and post-2014.
* The output of these commands can be observed in the log file.

use cnr_latvia_weekly
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen month = 1 if week<=5
replace month = 2 if week >=6 & week <=9
replace month = 3 if week >=10 & week <=13
replace month = 4 if week >=14 & week <=17
replace month = 5 if week >=18 & week <=22
replace month = 6 if week >=23 & week <=26
replace month = 7 if week >=27 & week <=30
replace month = 8 if week >=31 & week <=35
replace month = 9 if week >=36 & week <=39
replace month = 10 if week >=40 & week <=43
replace month = 11 if week >=44 & week <=47
replace month = 12 if week >=48 & week <=52
keep if year==2012 | year==2013
keep id year month
duplicates drop
bys year month: egen monthcount = count(id)
keep year month monthcount
duplicates drop
sum monthcount
clear

use cnr_latvia_weekly
keep if country=="lv"
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen month = 1 if week<=5
replace month = 2 if week >=6 & week <=9
replace month = 3 if week >=10 & week <=13
replace month = 4 if week >=14 & week <=17
replace month = 5 if week >=18 & week <=22
replace month = 6 if week >=23 & week <=26
replace month = 7 if week >=27 & week <=30
replace month = 8 if week >=31 & week <=35
replace month = 9 if week >=36 & week <=39
replace month = 10 if week >=40 & week <=43
replace month = 11 if week >=44 & week <=47
replace month = 12 if week >=48 & week <=52
keep if year==2012 | year==2013
keep id year month
duplicates drop
bys year month: egen monthcount = count(id)
keep year month monthcount
duplicates drop
sum monthcount
clear

use cnr_latvia_weekly
keep if country=="fr"
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen month = 1 if week<=5
replace month = 2 if week >=6 & week <=9
replace month = 3 if week >=10 & week <=13
replace month = 4 if week >=14 & week <=17
replace month = 5 if week >=18 & week <=22
replace month = 6 if week >=23 & week <=26
replace month = 7 if week >=27 & week <=30
replace month = 8 if week >=31 & week <=35
replace month = 9 if week >=36 & week <=39
replace month = 10 if week >=40 & week <=43
replace month = 11 if week >=44 & week <=47
replace month = 12 if week >=48 & week <=52
keep if year==2012 | year==2013
keep id year month
duplicates drop
bys year month: egen monthcount = count(id)
keep year month monthcount
duplicates drop
sum monthcount
clear

use cnr_latvia_weekly
keep if country=="it"
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen month = 1 if week<=5
replace month = 2 if week >=6 & week <=9
replace month = 3 if week >=10 & week <=13
replace month = 4 if week >=14 & week <=17
replace month = 5 if week >=18 & week <=22
replace month = 6 if week >=23 & week <=26
replace month = 7 if week >=27 & week <=30
replace month = 8 if week >=31 & week <=35
replace month = 9 if week >=36 & week <=39
replace month = 10 if week >=40 & week <=43
replace month = 11 if week >=44 & week <=47
replace month = 12 if week >=48 & week <=52
keep if year==2012 | year==2013
keep id year month
duplicates drop
bys year month: egen monthcount = count(id)
keep year month monthcount
duplicates drop
sum monthcount
clear

use cnr_latvia_weekly
keep if country=="de"
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen month = 1 if week<=5
replace month = 2 if week >=6 & week <=9
replace month = 3 if week >=10 & week <=13
replace month = 4 if week >=14 & week <=17
replace month = 5 if week >=18 & week <=22
replace month = 6 if week >=23 & week <=26
replace month = 7 if week >=27 & week <=30
replace month = 8 if week >=31 & week <=35
replace month = 9 if week >=36 & week <=39
replace month = 10 if week >=40 & week <=43
replace month = 11 if week >=44 & week <=47
replace month = 12 if week >=48 & week <=52
keep if year==2012 | year==2013
keep id year month
duplicates drop
bys year month: egen monthcount = count(id)
keep year month monthcount
duplicates drop
sum monthcount
clear

use cnr_latvia_weekly
keep if country=="us"
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen month = 1 if week<=5
replace month = 2 if week >=6 & week <=9
replace month = 3 if week >=10 & week <=13
replace month = 4 if week >=14 & week <=17
replace month = 5 if week >=18 & week <=22
replace month = 6 if week >=23 & week <=26
replace month = 7 if week >=27 & week <=30
replace month = 8 if week >=31 & week <=35
replace month = 9 if week >=36 & week <=39
replace month = 10 if week >=40 & week <=43
replace month = 11 if week >=44 & week <=47
replace month = 12 if week >=48 & week <=52
keep if year==2012 | year==2013
keep id year month
duplicates drop
bys year month: egen monthcount = count(id)
keep year month monthcount
duplicates drop
sum monthcount
clear

use exchange_long_weekly_weuro
rename country_string country
joinby date country using cnr_latvia_weekly
gen price_eur = price * eurx
gen year=floor(date/52)+1960

sum price_eur if year==2012 | year==2013,d
sum price_eur if (year==2012 | year==2013) & country=="lv",d
sum price_eur if (year==2012 | year==2013) & country=="fr",d
sum price_eur if (year==2012 | year==2013) & country=="it",d
sum price_eur if (year==2012 | year==2013) & country=="de",d
sum price_eur if (year==2012 | year==2013) & country=="us",d
clear

use cnr_latvia_weekly
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen month = 1 if week<=5
replace month = 2 if week >=6 & week <=9
replace month = 3 if week >=10 & week <=13
replace month = 4 if week >=14 & week <=17
replace month = 5 if week >=18 & week <=22
replace month = 6 if week >=23 & week <=26
replace month = 7 if week >=27 & week <=30
replace month = 8 if week >=31 & week <=35
replace month = 9 if week >=36 & week <=39
replace month = 10 if week >=40 & week <=43
replace month = 11 if week >=44 & week <=47
replace month = 12 if week >=48 & week <=52
keep if year==2014
keep id year month
duplicates drop
bys year month: egen monthcount = count(id)
keep year month monthcount
duplicates drop
sum monthcount
clear

use cnr_latvia_weekly
keep if country=="lv"
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen month = 1 if week<=5
replace month = 2 if week >=6 & week <=9
replace month = 3 if week >=10 & week <=13
replace month = 4 if week >=14 & week <=17
replace month = 5 if week >=18 & week <=22
replace month = 6 if week >=23 & week <=26
replace month = 7 if week >=27 & week <=30
replace month = 8 if week >=31 & week <=35
replace month = 9 if week >=36 & week <=39
replace month = 10 if week >=40 & week <=43
replace month = 11 if week >=44 & week <=47
replace month = 12 if week >=48 & week <=52
keep if year==2014
keep id year month
duplicates drop
bys year month: egen monthcount = count(id)
keep year month monthcount
duplicates drop
sum monthcount
clear

use cnr_latvia_weekly
keep if country=="fr"
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen month = 1 if week<=5
replace month = 2 if week >=6 & week <=9
replace month = 3 if week >=10 & week <=13
replace month = 4 if week >=14 & week <=17
replace month = 5 if week >=18 & week <=22
replace month = 6 if week >=23 & week <=26
replace month = 7 if week >=27 & week <=30
replace month = 8 if week >=31 & week <=35
replace month = 9 if week >=36 & week <=39
replace month = 10 if week >=40 & week <=43
replace month = 11 if week >=44 & week <=47
replace month = 12 if week >=48 & week <=52
keep if year==2014
keep id year month
duplicates drop
bys year month: egen monthcount = count(id)
keep year month monthcount
duplicates drop
sum monthcount
clear

use cnr_latvia_weekly
keep if country=="it"
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen month = 1 if week<=5
replace month = 2 if week >=6 & week <=9
replace month = 3 if week >=10 & week <=13
replace month = 4 if week >=14 & week <=17
replace month = 5 if week >=18 & week <=22
replace month = 6 if week >=23 & week <=26
replace month = 7 if week >=27 & week <=30
replace month = 8 if week >=31 & week <=35
replace month = 9 if week >=36 & week <=39
replace month = 10 if week >=40 & week <=43
replace month = 11 if week >=44 & week <=47
replace month = 12 if week >=48 & week <=52
keep if year==2014
keep id year month
duplicates drop
bys year month: egen monthcount = count(id)
keep year month monthcount
duplicates drop
sum monthcount
clear

use cnr_latvia_weekly
keep if country=="de"
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen month = 1 if week<=5
replace month = 2 if week >=6 & week <=9
replace month = 3 if week >=10 & week <=13
replace month = 4 if week >=14 & week <=17
replace month = 5 if week >=18 & week <=22
replace month = 6 if week >=23 & week <=26
replace month = 7 if week >=27 & week <=30
replace month = 8 if week >=31 & week <=35
replace month = 9 if week >=36 & week <=39
replace month = 10 if week >=40 & week <=43
replace month = 11 if week >=44 & week <=47
replace month = 12 if week >=48 & week <=52
keep if year==2014
keep id year month
duplicates drop
bys year month: egen monthcount = count(id)
keep year month monthcount
duplicates drop
sum monthcount
clear

use cnr_latvia_weekly
keep if country=="us"
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen month = 1 if week<=5
replace month = 2 if week >=6 & week <=9
replace month = 3 if week >=10 & week <=13
replace month = 4 if week >=14 & week <=17
replace month = 5 if week >=18 & week <=22
replace month = 6 if week >=23 & week <=26
replace month = 7 if week >=27 & week <=30
replace month = 8 if week >=31 & week <=35
replace month = 9 if week >=36 & week <=39
replace month = 10 if week >=40 & week <=43
replace month = 11 if week >=44 & week <=47
replace month = 12 if week >=48 & week <=52
keep if year==2014
keep id year month
duplicates drop
bys year month: egen monthcount = count(id)
keep year month monthcount
duplicates drop
sum monthcount
clear

use exchange_long_weekly_weuro
rename country_string country
joinby date country using cnr_latvia_weekly
gen price_eur = price * eurx if country!="lv"
replace price_eur = price if country=="lv"
gen year=floor(date/52)+1960

sum price_eur if year==2014,d
sum price_eur if year==2014 & country=="lv",d
sum price_eur if year==2014 & country=="fr",d
sum price_eur if year==2014 & country=="it",d
sum price_eur if year==2014 & country=="de",d
sum price_eur if year==2014 & country=="us",d

clear

use tmp_base
gen month = 1 if week<=5
replace month = 2 if week >=6 & week <=9
replace month = 3 if week >=10 & week <=13
replace month = 4 if week >=14 & week <=17
replace month = 5 if week >=18 & week <=22
replace month = 6 if week >=23 & week <=26
replace month = 7 if week >=27 & week <=30
replace month = 8 if week >=31 & week <=35
replace month = 9 if week >=36 & week <=39
replace month = 10 if week >=40 & week <=43
replace month = 11 if week >=44 & week <=47
replace month = 12 if week >=48 & week <=52
keep if year==2014
keep id country_i country_j year month
duplicates drop
bys country_i country_j year month: egen numb = count(id)
keep country_i country_j year month numb
duplicates drop
sum numb if country_i=="de" & country_j=="lv", d
sum numb if country_i=="lv" & country_j=="us", d
clear

use tmp_base
keep id country_i country_j year
duplicates drop
bys country_i country_j year: egen numb = count(id)
keep country_i country_j year numb
duplicates drop
sum numb if country_i=="de" & country_j=="lv", d
sum numb if country_i=="lv" & country_j=="us", d
clear

* Following lines generate updownshare_zara.pdf, which appears as Figure 2 in our paper.

use cnr_latvia_weekly
keep if country=="lv" & store=="Zara"
sort id date
gen up = 1 if !missing(price) & !missing(price[_n-1]) & price>price[_n-1] & id==id[_n-1]
gen down = 1 if !missing(price) & !missing(price[_n-1]) & price<price[_n-1] & id==id[_n-1]
gen same = 1 if !missing(price) & !missing(price[_n-1]) & id==id[_n-1]
bys date: egen upchangesharenum = sum(up)
bys date: egen downchangesharenum = sum(down)
bys date: egen changeshareden = count(same)
gen upchangeshare = 100*upchangesharenum/changeshareden
gen downchangeshare = 100*downchangesharenum/changeshareden
keep date upchangeshare downchangeshare changeshareden
duplicates drop
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen yearlab = year+(week-1)/52
line upchangeshare yearlab if (year!=2013 | week!=27) & changeshareden>=1000, legend(label(1 "Increases")) lpattern(shortdash) lcolor(blue) title("Latvia") lwidth(medthick) xlabel(2012(1)2015) ylabel(0(25)100) graphregion(color(white)) xtitle("") ytitle("") xline(2014, lcolor(red) lpattern(dash)) || line downchangeshare yearlab if (year!=2013 | week!=27) & changeshareden>=1000, legend(label(2 "Reductions")) lpattern(longdash) lcolor(green) lwidth(medthick) 	 
graph save "graphs\updownshare_zara_lv", replace
sum upchangeshare if (year!=2013 | week!=27), d
sum downchangeshare if (year!=2013 | week!=27), d
clear

use cnr_latvia_weekly
keep if country=="fr" & store=="Zara"
sort id date
gen up = 1 if !missing(price) & !missing(price[_n-1]) & price>price[_n-1] & id==id[_n-1]
gen down = 1 if !missing(price) & !missing(price[_n-1]) & price<price[_n-1] & id==id[_n-1]
gen same = 1 if !missing(price) & !missing(price[_n-1]) & id==id[_n-1]
bys date: egen upchangesharenum = sum(up)
bys date: egen downchangesharenum = sum(down)
bys date: egen changeshareden = count(same)
gen upchangeshare = 100*upchangesharenum/changeshareden
gen downchangeshare = 100*downchangesharenum/changeshareden
keep date upchangeshare downchangeshare changeshareden
duplicates drop
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen yearlab = year+(week-1)/52
line upchangeshare yearlab if (year!=2013 | week!=27) & changeshareden>=1000, legend(label(1 "Increases")) lpattern(shortdash) lcolor(blue) title("France") lwidth(medthick) xlabel(2012(1)2015) ylabel(0(25)100) graphregion(color(white)) xtitle("") ytitle("") xline(2014, lcolor(red) lpattern(dash)) || line downchangeshare yearlab if (year!=2013 | week!=27) & changeshareden>=1000, legend(label(2 "Reductions")) lpattern(longdash) lcolor(green) lwidth(medthick) 	 
graph save "graphs\updownshare_zara_fr", replace
sum upchangeshare if (year!=2013 | week!=27), d
sum downchangeshare if (year!=2013 | week!=27), d
clear

use cnr_latvia_weekly
keep if country=="de" & store=="Zara"
sort id date
gen up = 1 if !missing(price) & !missing(price[_n-1]) & price>price[_n-1] & id==id[_n-1]
gen down = 1 if !missing(price) & !missing(price[_n-1]) & price<price[_n-1] & id==id[_n-1]
gen same = 1 if !missing(price) & !missing(price[_n-1]) & id==id[_n-1]
bys date: egen upchangesharenum = sum(up)
bys date: egen downchangesharenum = sum(down)
bys date: egen changeshareden = count(same)
gen upchangeshare = 100*upchangesharenum/changeshareden
gen downchangeshare = 100*downchangesharenum/changeshareden
keep date upchangeshare downchangeshare changeshareden
duplicates drop
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen yearlab = year+(week-1)/52
line upchangeshare yearlab if (year!=2013 | week!=26) & changeshareden>=1000, legend(label(1 "Increases")) lpattern(shortdash) lcolor(blue) title("Germany") lwidth(medthick) xlabel(2012(1)2015) ylabel(0(25)100) graphregion(color(white)) xtitle("") ytitle("") xline(2014, lcolor(red) lpattern(dash)) || line downchangeshare yearlab if (year!=2013 | week!=26) & changeshareden>=1000, legend(label(2 "Reductions")) lpattern(longdash) lcolor(green) lwidth(medthick) 	 
graph save "graphs\updownshare_zara_de", replace
sum upchangeshare if (year!=2013 | week!=26), d
sum downchangeshare if (year!=2013 | week!=26), d
clear

use cnr_latvia_weekly
keep if country=="it" & store=="Zara"
sort id date
gen up = 1 if !missing(price) & !missing(price[_n-1]) & price>price[_n-1] & id==id[_n-1]
gen down = 1 if !missing(price) & !missing(price[_n-1]) & price<price[_n-1] & id==id[_n-1]
gen same = 1 if !missing(price) & !missing(price[_n-1]) & id==id[_n-1]
bys date: egen upchangesharenum = sum(up)
bys date: egen downchangesharenum = sum(down)
bys date: egen changeshareden = count(same)
gen upchangeshare = 100*upchangesharenum/changeshareden
gen downchangeshare = 100*downchangesharenum/changeshareden
keep date upchangeshare downchangeshare changeshareden
duplicates drop
gen year=floor(date/52)+1960
gen week=date-52*(year-1960)+1
gen yearlab = year+(week-1)/52
line upchangeshare yearlab if (year!=2013 | week!=28) & changeshareden>=1000, legend(label(1 "Increases")) lpattern(shortdash) lcolor(blue) title("Italy") lwidth(medthick) xlabel(2012(1)2015) ylabel(0(25)100) graphregion(color(white)) xtitle("") ytitle("") xline(2014, lcolor(red) lpattern(dash)) || line downchangeshare yearlab if (year!=2013 | week!=28) & changeshareden>=1000, legend(label(2 "Reductions")) lpattern(longdash) lcolor(green) lwidth(medthick) 	 
graph save "graphs\updownshare_zara_it", replace
sum upchangeshare if (year!=2013 | week!=28), d
sum downchangeshare if (year!=2013 | week!=28), d
clear

cd "graphs"

grc1leg "updownshare_zara_lv.gph" "updownshare_zara_fr.gph" "updownshare_zara_de.gph" "updownshare_zara_it.gph", graphregion(color(white)) rows(2) position(6)
graph export "updownshare_zara.pdf", as(pdf) replace

log close
