clear all
set matsize 5000
set maxvar 32000
set more off
pause on

*Enter the folder where you have placed the replication files and data
cd "C:\REPLICATION"

*Creates a folder called Output and saves the results and temporary files inside. 
capture rmdir "Output"
capture mkdir "Output"
cd "Output"

use "..\Input\exchange_long.dta"
gen week = week(date)
gen year = year(date)
replace date = yw(year,week)
format date %tw
bys country date: egen usdx_week = mean(usdx)
drop year week usdx
duplicates drop date country usdx_week, force
rename usdx_week usdx
save exchange_long_weekly, replace
keep country
duplicates drop
rename country_string country
save country_list, replace
clear

use "..\Input\CNR_Latvia_IMFER.dta"
gen store = "Zara"
drop if country=="13701" | country=="file:"
replace country = "uk" if country=="gb"
replace country = "po" if country=="pl"
drop if country=="xf"
save cnr_latvia, replace
joinby country using country_list
gen week = week(date)
gen year = year(date)
bys country store id idc year week: egen intro_week = sum(intro)
bys country store id idc year week: egen price_week = max(price)
drop intro price date
rename intro_week intro
rename price_week price
duplicates drop id idc country store week year intro price, force
gen date=yw(year,week)
format date %tw
drop year week
order store country id idc date intro price
sort store country id date
joinby country using country_list
save cnr_latvia_weekly, replace
rm cnr_latvia.dta
levelsof country, local(countries)
foreach cty of local countries {
	clear
	use cnr_latvia_weekly
	keep if country=="`cty'"
	foreach var in "intro" "price" {
		rename `var' `var'_`cty'
	}
	save cnr_latvia_weekly_`cty', replace
}
clear

use cnr_latvia_weekly
levelsof country, local(countries_i)
levelsof country, local(countries_j)
foreach cty_i of local countries_i {
	foreach cty_j of local countries_j {
		if "`cty_i'"<"`cty_j'" {
			di "`cty_i'`cty_j'"
			clear
			use cnr_latvia_weekly_`cty_i'
			drop idc country
			joinby store id date using cnr_latvia_weekly_`cty_j', unmatched(both)
			drop idc country
			gen country_i="`cty_i'"
			gen country_j="`cty_j'"
			gen both = 1 if _merge==3
			replace both = 0 if missing(both)
			drop _merge
			bys store id: egen common = max(both)
			keep if common==1
			sum id
			if r(N)>=1 {
				bys store id: egen hasintro_`cty_i' = sum(intro_`cty_i')
				bys store id: egen hasintro_`cty_j' = sum(intro_`cty_j')
				gen intros = 0
				replace intros = 1 if hasintro_`cty_i'==1 & hasintro_`cty_j'==1
				gen date_`cty_i'_tmp = date if !missing(price_`cty_i')
				gen date_`cty_j'_tmp = date if !missing(price_`cty_j')
				bys store id: egen mindate_`cty_i' = min(date_`cty_i'_tmp)
				bys store id: egen mindate_`cty_j' = min(date_`cty_j'_tmp)
				format mindate_`cty_i' mindate_`cty_j' %tw
				gen maxgap = abs(mindate_`cty_i'-mindate_`cty_j')
				save cnr_latvia_weekly_`cty_i'`cty_j'_wprice, replace
				use exchange_long_weekly
				keep if country=="`cty_i'"
				rename usdx usdx_`cty_i'
				rename country country_i
				joinby date country_i using cnr_latvia_weekly_`cty_i'`cty_j'_wprice
				save cnr_latvia_weekly_`cty_i'`cty_j'_wprice, replace
				use exchange_long_weekly
				keep if country=="`cty_j'"
				rename usdx usdx_`cty_j'
				rename country country_j
				joinby date country_j using cnr_latvia_weekly_`cty_i'`cty_j'_wprice
				gen er_`cty_i'`cty_j' = usdx_`cty_j'/usdx_`cty_i'
				gen pintro_`cty_i'_tmp = price_`cty_i' if date==mindate_`cty_i'
				gen pintro_`cty_j'_tmp = price_`cty_j' if date==mindate_`cty_j'
				gen erintro_`cty_i'_tmp = er_`cty_i'`cty_j' if date==mindate_`cty_i'
				gen erintro_`cty_j'_tmp = er_`cty_i'`cty_j' if date==mindate_`cty_j'
				bys store id: egen pintro_`cty_i' = mean(pintro_`cty_i'_tmp)
				bys store id: egen pintro_`cty_j' = mean(pintro_`cty_j'_tmp)
				bys store id: egen erintro_`cty_i' = mean(erintro_`cty_i'_tmp)
				bys store id: egen erintro_`cty_j' = mean(erintro_`cty_j'_tmp)
				keep both store id date country_i country_j er_`cty_i'`cty_j' price_`cty_i' price_`cty_j' pintro_`cty_i' pintro_`cty_j' erintro_`cty_i' erintro_`cty_j' mindate_`cty_i' mindate_`cty_j' intros maxgap
				order store id date country_i country_j er_`cty_i'`cty_j' price_`cty_i' price_`cty_j' pintro_`cty_i' pintro_`cty_j' erintro_`cty_i' erintro_`cty_j' mindate_`cty_i' mindate_`cty_j' intros
				sort store id date
				bys store id: gen change_`cty_i' = 1 if price_`cty_i'!=price_`cty_i'[_n-1] & store==store[_n-1] & id==id[_n-1]
				bys store id: gen change_`cty_j' = 1 if price_`cty_j'!=price_`cty_j'[_n-1] & store==store[_n-1] & id==id[_n-1]
				replace change_`cty_i'=0 if missing(change_`cty_i')
				replace change_`cty_j'=0 if missing(change_`cty_j')
				gen erlast_`cty_i' = erintro_`cty_i' if date==mindate_`cty_i'
				bys store id: replace erlast_`cty_i' = er_`cty_i'`cty_j' if change_`cty_i'==1
				bys store id: replace erlast_`cty_i' = erlast_`cty_i'[_n-1] if date!=mindate_`cty_i' & change_`cty_i'==0  & store==store[_n-1] & id==id[_n-1]
				gen erlast_`cty_j' = erintro_`cty_j' if date==mindate_`cty_j'
				bys store id: replace erlast_`cty_j' = er_`cty_i'`cty_j' if change_`cty_j'==1
				bys store id: replace erlast_`cty_j' = erlast_`cty_j'[_n-1] if date!=mindate_`cty_j' & change_`cty_j'==0  & store==store[_n-1] & id==id[_n-1]
				keep if both==1
				gen qij = ln(price_`cty_i') - ln(er_`cty_i'`cty_j') - ln(price_`cty_j')
				gen qij1 = ln(pintro_`cty_i') - ln(pintro_`cty_j') - 0.5*(ln(erintro_`cty_i')+ln(erintro_`cty_j'))
				gen qij2 = (ln(price_`cty_i')-ln(pintro_`cty_i'))-(ln(price_`cty_j')-ln(pintro_`cty_j'))-1/2*((ln(erlast_`cty_i')-ln(erintro_`cty_i'))+(ln(erlast_`cty_j')-ln(erintro_`cty_j')))
				gen qij3 = -1/2*((ln(er_`cty_i'`cty_j')-ln(erlast_`cty_i'))+(ln(er_`cty_i'`cty_j')-ln(erlast_`cty_j')))				
				rename er_`cty_i'`cty_j' er_ij
				keep price_`cty_i' price_`cty_j' country_i country_j date store id er_ij qij qij1 qij2 qij3 intros maxgap
				rename price_`cty_i' price_i
				rename price_`cty_j' price_j
				save cnr_latvia_weekly_`cty_i'`cty_j'_wprice, replace
		}
		}
	}
}
clear	

use cnr_latvia_weekly
levelsof country, local(countries_i)
levelsof country, local(countries_j)
use cnr_latvia_weekly_jpus_wprice
drop if _n>=1
save cnr_latvia_weekly_bilat_wprice, replace
foreach cty_i of local countries_i {
	foreach cty_j of local countries_j {
		if "`cty_i'"<"`cty_j'" {
			display "`cty_i'`cty_j'"
			capture append using cnr_latvia_weekly_`cty_i'`cty_j'_wprice
			count
		}
	}
}
drop if country_i=="ic" | country_j=="ic"
save "cnr_latvia_weekly_bilat_nocats_wprice.dta", replace
clear

insheet using "..\Input\COUNTRIES.csv", comma
rename code country
rename name ctylab
rename dollarized usd
rename vatsalestax vat
rename taxincludedinprice hastax
replace country = lower(country)
destring usd europe euro, replace
save "cnr_covars.dta", replace
clear

use "cnr_latvia_weekly_bilat_nocats_wprice.dta"
keep country_i country_j er_ij date
duplicates drop
gen lner_ij = ln(er_ij)
bys country_i country_j: egen fxvar = sd(lner_ij)
drop lner_ij
replace fxvar = fxvar^2
keep country_i country_j fxvar
duplicates drop
xtile fxvar_tile = fxvar, nq(3)
save "fxvar.dta", replace
clear

use "cnr_covars.dta"
keep vat hastax country
rename vat vat_i
rename hastax hastax_i
rename country country_i
joinby country_i using "cnr_latvia_weekly_bilat_nocats_wprice.dta"
save "cnr_latvia_weekly_bilat_nocats_wprice.dta", replace
clear
use "cnr_covars.dta"
keep vat hastax country
rename vat vat_j
rename hastax hastax_j
rename country country_j
joinby country_j using "cnr_latvia_weekly_bilat_nocats_wprice.dta"
replace qij = qij+ln(1+vat_i/100) if hastax_i==0
replace qij = qij-ln(1+vat_j/100) if hastax_j==0
replace qij1 = qij1+ln(1+vat_i/100) if hastax_i==0
replace qij1 = qij1-ln(1+vat_j/100) if hastax_j==0
drop vat* hastax*
save "cnr_latvia_weekly_bilat_nocats_wprice.dta", replace
clear

use "cnr_latvia_weekly_bilat_nocats_wprice.dta"
keep country_i country_j
duplicates drop
save "countrylist.dta", replace
clear

insheet using "..\Input\gdpweights.csv", comma
drop v3
replace v1 = lower(v1)
rename v1 country_i
rename v2 gdp_i
destring gdp_i, replace force
drop if missing(gdp_i)
save "gdp_i.dta", replace
clear
insheet using "..\Input\gdpweights.csv", comma
drop v3
replace v1 = lower(v1)
rename v1 country_j
rename v2 gdp_j
destring gdp_j, replace force
drop if missing(gdp_j)
save "gdp_j.dta", replace
clear

insheet using "..\Input\iso_concord.csv", comma names
gen country_code = lower(ckn_code)
replace iso = lower(iso)
keep country iso
drop if missing(iso) | missing(country_code)
save "iso_concord.dta", replace
clear

insheet using "..\Input\pcgdp.csv", comma names
keep cgdp iso
rename cgdp cgdp07
drop if missing(cgdp07)
replace iso = lower(iso)
save "cgdp.dta", replace
clear

use exchange_long_weekly
rename country country_i
rename usdx usdpercur_i
joinby date country_i using "cnr_latvia_weekly_bilat_nocats_wprice.dta"
save "cnr_latvia_weekly_bilat_nocats_wprice.dta", replace
clear

