clear all
set type double
set matsize 5000
set maxvar 32000
set more off
clear

* Assumes initial directory path is set to Codes folder
cd ".."
cap mkdir Temp
cap mkdir Temp\K_cases

foreach case in "pi_resid" "k_resid" "r_resid" {

	use Output_Files\KN_MA_Input_Data.dta if !missing(X_nit) & !missing(pK_nit) & !missing(xi_nit), clear
	replace pK_it = 1 if missing(pK_it)
	replace K_it = 1e-6 if missing(pK_it)
	replace xi_it = 1 if missing(xi_it)
	replace X_it = 1e-6 if missing(X_it)
	gsort -year
	foreach vars in "taux" "tauk" "tauc" "taun" {
		replace `vars' = `vars'[_n-1] if missing(`vars')
	}
	foreach vars in "POP" "Hours" {
		replace `vars' = (`vars'[_n-1])^2/`vars'[_n-2] if missing(`vars')
	}
	gsort -year
	replace r_US10 = r_AAA*(r_US10[_n-1]/r_AAA[_n-1]) if missing(r_US10)
	replace POP = POP[_n-1]*(POP[_n-1]/POP[_n-2]) if missing(POP)
	sort year
	sum year
	local startyr = `r(min)'
	local endyr = `r(max)'
	
	gen numeraire = pCexH
	foreach nomval in "pY" "pYY" "pC" "pCC" "pH" "pHH" "pG" "pGG" "pYexH" "pYexHYexH" "pYexG" "pYexGYexG" "pYexHexG" "pYexHexGYexHexG" "pCexH" "pCexHCexH" "xi_it" "X_it" "xi_nit" "X_nit" "xi_res" "X_res" "xi_gov" "X_gov" "pK_it" "pK_nit" "pK_res" "pK_gov" "WN" "WN_gov"  {
		replace `nomval'=`nomval'/numeraire
	}		
	foreach realval in "Y" "C" "H" "G" "YexH" "YexG" "YexHexG" "CexH" {
		gen `realval' = p`realval'`realval'/p`realval'
	}
	
	gen irate = 1+r_US10/100
	gen infl5 = (numeraire[_n+3]/numeraire[_n-2])^(1/5)	
	gen r = irate/infl5-1
	replace r=r_US10/r_US10[_n-1]*r[_n-1] if missing(r)
	gsort -year
	replace r=r_US10/r_US10[_n-1]*r[_n-1] if missing(r)
	sort year
	drop r_* numeraire irate* infl*

	gen N = Hours/POP
	gen W = WN/N
	gen N_gov = Hours_gov/POP
	gen W_gov = WN_gov/N_gov

	*Remove Government
	replace WN = WN-WN_gov
	replace N = N-N_gov
	replace W = (WN)/N
	replace pY = pYexG
	replace Y = YexG
	replace pYY = pYexGYexG
	replace pYexH = pYexHexG
	replace pYexHYexH = pYexHexGYexHexG
	replace YexH = YexHexG			
	replace K_gov=0
	replace X_gov=0
	drop pYexG pYexGYexG pG pGG pYexHexG pYexHexGYexHexG
	drop WN* FTE* Hours* POP
	gen sL = (W*N)/(pYY)
	
	foreach ktype in "it" "nit" "res" "gov" {
		replace xi_`ktype' = pK_`ktype'
		drop pK_`ktype'
		replace K_`ktype' = 0 if year==`startyr' & missing(K_`ktype')
		gen I_`ktype' = X_`ktype'/xi_`ktype'
		replace K_`ktype' = K_`ktype'[_n-1]*(1-delta_`ktype')+I_`ktype'[_n-1] if year>`startyr'
		gen R_`ktype' = (1+taux)/(1-tauk)*xi_`ktype'*(((1+taux[_n-1])*xi_`ktype'[_n-1])/((1+taux)*xi_`ktype')*(1+(1-tauk)*r) - (1-delta_`ktype')-tauk*delta_`ktype'/(1+taux))
		replace R_`ktype' = (1+taux)/(1-tauk)*xi_`ktype'*(((1+taux)*xi_`ktype')/((1+taux)*xi_`ktype')*(1+(1-tauk)*r) - (1-delta_`ktype')-tauk*delta_`ktype'/(1+taux)) if missing(R_`ktype') & _n==1
		if "`ktype'"=="gov" {
			replace R_`ktype' = (1+taux)/(1-tauk)*xi_`ktype'*(((1+taux[_n-1])*xi_`ktype'[_n-1])/((1+taux)*xi_`ktype')*(1+(1-tauk)*0) - (1-delta_`ktype')-tauk*delta_`ktype'/(1+taux))
			replace R_`ktype' = (1+taux)/(1-tauk)*xi_`ktype'*(((1+taux)*xi_`ktype')/((1+taux)*xi_`ktype')*(1+(1-tauk)*0) - (1-delta_`ktype')-tauk*delta_`ktype'/(1+taux)) if missing(R_`ktype') & _n==1
		}
		replace R_`ktype'=0.000001 if R_`ktype'<0
		gen sK_`ktype' = (R_`ktype'*K_`ktype')/(pYY)
	}
	
	gen s_residual = (1-sL-sK_it-sK_nit-sK_res-sK_gov)		
	gen residual =  s_residual*pYY
	gen residual_H = (pHH-R_res*K_res)
	gen s_residual_H = residual_H/pHH
	gen residual_exH = residual-residual_H
	gen s_residual_exH = residual_exH/pYexHYexH

	if "`case'"=="pi_resid" {
		gen s_pi = s_residual
		gen s_pi_H = s_residual_H
		gen s_pi_exH = s_residual_exH
		gen sK = sK_it+sK_nit+sK_res
		gen sL_exH = W*N/(pYexHYexH)
		gen sK_it_exH = R_it*K_it/(pYexHYexH)
		gen sK_nit_exH = R_nit*K_nit/(pYexHYexH)
		foreach var in "sL_exH" "sK" "sL" "sK_it" "sK_nit" "sK_res" "s_pi" "s_pi_H" "s_pi_exH"  {
			gen `var'5 = (`var'[_n-2]+`var'[_n-1]+`var'+`var'[_n+1]+`var'[_n+2])/5
			gen `var'3 = (`var'[_n-1]+`var'+`var'[_n+1])/3
			replace `var'3 = `var' if missing(`var'3)
			replace `var'5 = `var'3 if missing(`var'5)
		}
		gen r5_plot = (r[_n-2]+r[_n-1]+r+r[_n+1]+r[_n+2])/5
		gen r3_plot = (r[_n-1]+r+r[_n+1])/3
		replace r3_plot = r if missing(r3_plot)
		replace r5_plot = r3_plot if missing(r5_plot)
		replace r5_plot = r if missing(r5_plot)

		line sL5 year if year>=1960, ytitle("Share of Value Added", height(6) size(4.5)) graphregion(color(white)) ylabel(0.45(0.05)0.70, labsize(4.0)) lp(solid) lc(black) legend(size(3.5)   label(1 "Labor") region(lcolor(white)) rows(1)) legend(on) xtitle("") xlabel(,labsize(4.0))
		graph export Output_Files\Figure_1a.eps, as(eps) replace
		graph export Output_Files\Figure_1a.pdf, as(pdf) replace
		line sK_it5 sK_nit5 sK_res5 year if year>=1960, ytitle("Share of Value Added", height(6) size(4.5)) lp(longdash dash_dot shortdash) lc(red blue green) graphregion(color(white)) ylabel(0.0(0.05)0.25, labsize(4.0)) legend(size(3.5)   label(1 "IT Capital") label(2 "Non-IT Capital") label(3 "Residential Capital") region(lcolor(white)) rows(1)) xtitle("") xlabel(,labsize(4.0))
		graph export Output_Files\Figure_1b.eps, as(eps) replace
		graph export Output_Files\Figure_1b.pdf, as(pdf) replace
		line s_pi_exH5 year if year>=1960, ylabel(0(0.05)0.25, labsize(4.0)) ytitle("Share of Business Value Added", height(6) size(4.5)) lp(solid) lc(black) graphregion(color(white)) || line r5_plot year if year>=1960, yaxis(2) ytitle("Percent", height(6) size(4.5) axis(2)) lp(dash) lc(red) legend(size(3.5)   label(1 "Business Profit Share") label(2 "Real Interest Rate (right axis)")  region(lcolor(white)) rows(1)) xtitle("") xlabel(,labsize(4.0))
		graph export Output_Files\Figure_2a.eps, as(eps) replace
		graph export Output_Files\Figure_2a.pdf, as(pdf) replace		
		line s_pi_H5 year if year>=1960, ylabel(0(0.25)1, labsize(4.0)) ytitle("Share of Housing Value Added", height(6) size(4.5)) lp(solid) lc(black) graphregion(color(white)) || line r5_plot year if year>=1960, yaxis(2) ytitle("Percent", height(6) size(4.5) axis(2)) lp(dash) lc(red) legend(size(3.5)   label(1 "Housing Profit Share") label(2 "Real Interest Rate (right axis)")  region(lcolor(white)) rows(1)) xtitle("") xlabel(,labsize(4.0))
		graph export Output_Files\Figure_2b.eps, as(eps) replace
		graph export Output_Files\Figure_2b.pdf, as(pdf) replace		
		
		* For TFP Calculations		
		foreach ftr in "Y" "YexH" "N" "K_it" "K_nit" "K_res" {
			gen dln_`ftr' = ln(`ftr')-ln(`ftr'[_n-1])
		}
		foreach ftr in "sL" "sK_it" "sK_nit" "sK_res" "sL_exH" "sK_it_exH" "sK_nit_exH" {
			gen tornq_`ftr' = 0.5*(`ftr'+`ftr'[_n-1])
		}
		gen dln_TFP_exH = dln_YexH - (tornq_sL_exH * dln_N) - (1-tornq_sL_exH)* (tornq_sK_it_exH / (tornq_sK_it_exH + tornq_sK_nit_exH)) * dln_K_it - (1-tornq_sL_exH)* (tornq_sK_nit_exH / (tornq_sK_it_exH + tornq_sK_nit_exH)) * dln_K_nit
		gen dln_Tech_exH = dln_YexH - tornq_sL_exH/(tornq_sL_exH+tornq_sK_it_exH+tornq_sK_nit_exH)*dln_N - tornq_sK_it_exH/(tornq_sL_exH+tornq_sK_it_exH+tornq_sK_nit_exH)*dln_K_it - tornq_sK_nit_exH/(tornq_sL_exH+tornq_sK_it_exH+tornq_sK_nit_exH)*dln_K_nit
		gen decade = "1960-1965" if year>=1960 & year<=1965
		replace decade = "1966-1975" if year>=1966 & year<=1975
		replace decade = "1976-1985" if year>=1976 & year<=1985
		replace decade = "1986-1995" if year>=1986 & year<=1995
		replace decade = "1996-2005" if year>=1996 & year<=2005
		replace decade = "2006-2015" if year>=2006 & year<=2015
		collapse (mean) dln_TFP_exH dln_Tech_exH, by(decade)
		rename (dln_TFP_exH dln_Tech_exH) (Case0_TFP Case1_TFP)
		save Temp\tfp_case_pi, replace
	}

	if "`case'"=="k_resid" {	
		gen R_u = .
		gen X_u = .
		gen row = _n
		gen xi_u = 1 if year==2009
		gen s_pi_H = s_residual_H
		
		* Generate simulations for a grid of values of delta_u, s_pi_exH, and K_u/Y (in 2010)
		forvalues delta_u_loop = 0.01(.01)0.25 {
			local delta_u_name = round(`delta_u_loop'*100)
			forvalues s_pi_exH_loop = 0.00(.01)0.15 {
				local s_pi_exH_name = round(`s_pi_exH_loop'*100)
				forvalues K_u_loop = 0.1(0.1)2.5 {
					local K_u_name = round(`K_u_loop'*100)		
					preserve
					gen s_pi_exH = `s_pi_exH_loop'
					gen delta_u = `delta_u_loop'
					gen K_u = `K_u_loop'*pYY if year==2010										
					forvalues yr = 2010(1)`endyr' {
						sum row if year==`yr'
						local n = `r(mean)'
						local pos = 1
						local xigrow_case = 1
						while `pos' == 1 & `xigrow_case'<=51 {
							di "`pos'"
							di "`xigrow_case'"
							gen xi_u_`xigrow_case' = xi_u[_n-1]*(1+(`xigrow_case'-26)/100) if year==`yr'
							gen R_u_`xigrow_case' = (1+taux)/(1-tauk)*xi_u_`xigrow_case'*(((1+taux[_n-1])*xi_u[_n-1])/((1+taux)*xi_u_`xigrow_case')*(1+(1-tauk)*r) - (1-delta_u)-tauk*delta_u/(1+taux)) if year==`yr'
							replace R_u_`xigrow_case'=0.000001 if R_u_`xigrow_case'<0 & year==`yr'
							gen X_u_`xigrow_case' = -(pYY -W*N-R_it*K_it-R_nit*K_nit-R_res*K_res-R_gov*K_gov-R_u_`xigrow_case'*K_u-(s_pi_exH*pYexHYexH+s_pi_H*pHH)) if year==`yr'
							if X_u_`xigrow_case'[`n']>0 | `xigrow_case'==1 {
								di "yes! `xigrow_case'"
								replace xi_u = xi_u_`xigrow_case' if year==`yr'
								replace X_u = max(1e-6,X_u_`xigrow_case') if year==`yr'
								replace R_u = R_u_`xigrow_case' if year==`yr'
							} 
							else {
								di "no! `xigrow_case'"
								local pos = 0
							}
							local xigrow_case = `xigrow_case'+1
						}
						drop xi_u_* X_u_* R_u_*
						replace K_u = (1-delta_u[_n-1])*K_u[_n-1]+X_u[_n-1]/xi_u[_n-1] if year==`yr'+1
					}
					forvalues yr = 2009(-1)`startyr' {
						di "YEAR `yr'"
						sum row if year==`yr'
						local n = `r(mean)'
						local pos = 1
						local xigrow_case = 1
						while `pos' == 1 & `xigrow_case'<=51 {
							di "`pos'"
							di "`xigrow_case'"
							gen xi_u_`xigrow_case' = xi_u[_n+1]/(1+(`xigrow_case'-26)/100) if year==`yr'-1	
							gen R_u_`xigrow_case' = (1+taux)/(1-tauk)*xi_u*(((1+taux[_n-1])*xi_u_`xigrow_case'[_n-1])/((1+taux)*xi_u)*(1+(1-tauk)*r) - (1-delta_u)-tauk*delta_u/(1+taux)) if year==`yr'
							replace R_u_`xigrow_case'=0.000001 if R_u_`xigrow_case'<0 & year==`yr'
							gen X_u_`xigrow_case' = ( -(pYY -W*N-R_it*K_it-R_nit*K_nit-R_res*K_res-R_gov*K_gov-(s_pi_exH*pYexHYexH+s_pi_H*pHH)) + R_u_`xigrow_case'*K_u[_n+1]/(1-delta_u)) / (1 + R_u_`xigrow_case'/xi_u/(1-delta_u)) if year==`yr'
							if X_u_`xigrow_case'[`n']>0 | `xigrow_case'==1 {
								di "yes! `xigrow_case'"
								replace xi_u = xi_u_`xigrow_case' if year==`yr'-1
								replace X_u = max(1e-6,X_u_`xigrow_case') if year==`yr'
								replace R_u = R_u_`xigrow_case' if year==`yr'
							} 
							else {
								di "no! `xigrow_case'"
								local pos = 0
							}
							local xigrow_case = `xigrow_case'+1
						}
						drop xi_u_* X_u_* R_u_*
						replace K_u = (K_u[_n+1] - X_u/xi_u)/(1-delta_u) if year==`yr'
					}				
					gen XuYmratio = (X_u)/pYY
					gen YuYmratio = (X_u+pYY)/pYY
					gen KuYratio = (xi_u*K_u)/pYY
					gen KitYratio = (xi_it*K_it)/pYY
					gen KresYratio = (xi_res*K_res)/pYY
					gen KnitYratio = (xi_nit*K_nit)/pYY
					gen sltrue = W*N/(pYY+X_u)
					save Temp\K_cases\Case_`delta_u_name'_`s_pi_exH_name'_`K_u_name'.dta, replace
					restore
				}
			}
		}
		
		* Assemble all the various simulations
		clear
		forvalues delta_u_loop = 0.01(.01)0.25 {
			local delta_u_name = round(`delta_u_loop'*100)
			forvalues s_pi_exH_loop = 0(.01)0.15 {
				local s_pi_exH_name = round(`s_pi_exH_loop'*100)
				forvalues K_u_loop = 0.1(0.1)2.5 {
					local K_u_name = round(`K_u_loop'*100)				
					cap append using Temp\K_cases\Case_`delta_u_name'_`s_pi_exH_name'_`K_u_name'.dta
					local casecounter = `casecounter'+1
				}
			}
		}
		drop if year<`startyr'
		gen casecounter = 1 if year==`startyr'
		gen case = sum(casecounter)	
		drop casecounter

		* Keeps only those simulations with minimal (generally zero) negative investment values
		gen neg_X_u = 1 if X_u<1 & year>1960
		bys case: egen sum_neg_X_u = sum(neg_X_u)
		sum sum_neg_X_u
		keep if sum_neg_X_u == `r(min)'

		* Drops cases with extreme gap between min and max of price of unmeasured investment
		bys case: egen max_xi_u = max(xi_u)
		bys case: egen min_xi_u = min(xi_u)
		gen xi_ratio = max_xi_u/min_xi_u
		sum xi_ratio, d
		drop if xi_ratio>`r(p10)'
		count if xi_ratio<=2000
		if `r(N)'>0 {
			drop if xi_ratio>2000
		}

		* Drops cases where unmeasured capital relative to output is large in 1980 (relative to the other sims)
		bys case: egen max_KuYratio_80_tmp = max(KuYratio) if year>=1980
		bys case: egen max_KuYratio_80 = max(max_KuYratio_80_tmp)			
		sum max_KuYratio_80, d			
		count if max_KuYratio_80 <= `r(p10)'
		if `r(N)'>0 {
			sum max_KuYratio_80, d			
			drop if max_KuYratio_80 > `r(p10)'
		}
		
		* Drops cases where unmeasured capital price volatility is largest (relative to the other sims)
		bys case (year): gen dlnxi_u = ln(xi_u/xi_u[_n-1])
		bys case : egen sd_dlnxi_u = sd(dlnxi_u)
		sum sd_dlnxi_u, d
		count if sd_dlnxi_u<=`r(p25)'
		if `r(N)'>0 {
			sum sd_dlnxi_u, d
			drop if sd_dlnxi_u>`r(p25)'
		}
		
		* Drops cases with very large or very small depreciation rates of unmeasured capital, provided others remain
		sum delta_u, d
		local dmin = `r(min)'
		local dmax = `r(max)'
		if `dmin'<0.05 {
			drop if delta_u>0.2
		}
		if `dmax'<0.01 {
			drop if delta_u<=0.01
		}

		* Keeps the remaining case with maximal spending on unmeasured investment. 
		* Generally this makes little difference but have found cases where larger max is better.
		bys case: egen max_X_u = max(X_u)
		egen overallmax_X_u = max(max_X_u)
		sum case if max_X_u==overallmax_X_u
		keep if case==`r(mean)'
		
		drop case XuYmratio YuYmratio KuYratio KitYratio KresYratio KnitYratio sltrue max_xi_u min_xi_u xi_ratio dlnxi_u sd_dlnxi_u max_X_u overallmax_X_u
		gen sK_Q_it = R_it*K_it/(pYexHYexH+X_u)
		gen sK_Q_nit = R_nit*K_nit/(pYexHYexH+X_u)
		gen sK_Q_u = R_u*K_u/(pYexHYexH+X_u)
		gen sL_Q = W*N/(pYexHYexH+X_u)
		gen GDP_true = pYY+X_u
		gen m_Yshare = pYY/GDP_true
		gen u_Yshare = X_u/GDP_true
		gen growth_m = ln(Y/Y[_n-1])
		gen growth_u = ln((X_u/xi_u)/(X_u[_n-1]/xi_u[_n-1]))
		gen growth_true = 0.5*(m_Yshare+m_Yshare[_n-1])*growth_m + 0.5*(u_Yshare+u_Yshare[_n-1])*growth_u			
		gen s_KY_it = xi_it*K_it/(GDP_true)
		gen s_KY_nit = xi_nit*K_nit/(GDP_true)
		gen s_KY_u = xi_u*K_u/(GDP_true)
		gen s_KY_res = xi_res*K_res/(GDP_true)
		gen s_XY_it = X_it/GDP_true
		gen s_XY_nit = X_nit/GDP_true
		gen s_XY_u = X_u/GDP_true
		gen s_XY_res = X_res/GDP_true
		gen sL_Q_orig = W*N/pYexHYexH
		
		foreach var in "sL_Q_orig" "s_XY_it" "s_XY_nit" "s_XY_u" "s_XY_res" "s_KY_it" "s_KY_nit" "s_KY_u" "s_KY_res" "growth_m" "growth_true" "xi_it" "xi_nit" "xi_u" "xi_res" "R_it" "R_nit" "R_u" "R_res" "sL_Q" {
			gen `var'5 = (`var'[_n-2]+`var'[_n-1]+`var'+`var'[_n+1]+`var'[_n+2])/5
			gen `var'3 = (`var'[_n-1]+`var'+`var'[_n+1])/3
			replace `var'3 = `var' if missing(`var'3)
			replace `var'5 = `var'3 if missing(`var'5)
		}

		line xi_nit5 xi_u5 year if year>=1960, ytitle("Index", height(6) size(4.5)) lp(solid longdash) lc(black red) graphregion(color(white)) || line xi_it5 year if year>=1960, yaxis(2) ytitle("Index", height(6) size(4.5) axis(2)) lp(dash_dot) lc(blue) legend(size(3.5)   label(1 "Non-IT") label(2 "Unmeasured") label(3 "IT (right axis)")  region(lcolor(white)) rows(1)) xtitle("") xlabel(,labsize(4.0))
		graph export Output_Files\Figure_7a.eps, as(eps) replace
		graph export Output_Files\Figure_7a.pdf, as(pdf) replace		
		line R_nit5 R_u5 year if year>=1960, ytitle("Rental Rate", height(6) size(4.5)) lp(solid longdash) lc(black red) graphregion(color(white)) || line R_it5 year if year>=1960, yaxis(2) ytitle("Rental Rate", height(6) size(4.5) axis(2)) lp(dash_dot) lc(blue) legend(size(3.5)   label(1 "Non-IT") label(2 "Unmeasured") label(3 "IT (right axis)")  region(lcolor(white)) rows(1)) xtitle("") xlabel(,labsize(4.0))
		graph export Output_Files\Figure_7b.eps, as(eps) replace
		graph export Output_Files\Figure_7b.pdf, as(pdf) replace		
		line s_XY_nit5 s_XY_u5 s_XY_it5 s_XY_res5 year if year>=1960, ytitle("Investment Spending / GDP", height(6) size(4.5)) lp(solid longdash dash_dot shortdash) lc(black red blue green) graphregion(color(white)) legend(size(3.5)   label(1 "Non-IT") label(2 "Unmeasured") label(3 "IT") label(4 "Residential")  region(lcolor(white)) rows(1)) xtitle("") xlabel(,labsize(4.0))
		graph export Output_Files\Figure_7c.eps, as(eps) replace
		graph export Output_Files\Figure_7c.pdf, as(pdf) replace		
		line s_KY_nit5 s_KY_u5 s_KY_it5 s_KY_res5 year if year>=1960, ytitle("Capital Value / GDP", height(6) size(4.5)) lp(solid longdash dash_dot shortdash) lc(black red blue green) graphregion(color(white)) legend(size(3.5)   label(1 "Non-IT") label(2 "Unmeasured") label(3 "IT") label(4 "Residential")  region(lcolor(white)) rows(1)) xtitle("") xlabel(,labsize(4.0))
		graph export Output_Files\Figure_7d.eps, as(eps) replace
		graph export Output_Files\Figure_7d.pdf, as(pdf) replace		
		line growth_m5 growth_true5 year if year>=1960, ytitle("Growth (in logs)", height(6) size(4.5)) lp(solid dash) lc(black red) graphregion(color(white)) legend(size(3.5)   label(1 "Measured") label(2 "Revised") region(lcolor(white)) rows(1)) xtitle("") xlabel(,labsize(4.0))
		graph export Output_Files\Figure_8a.eps, as(eps) replace
		graph export Output_Files\Figure_8a.pdf, as(pdf) replace		
		line sL_Q_orig5 sL_Q5 year if year>=1960, ytitle("Share of Business Value Added", height(6) size(4.5)) lp(solid dash) lc(black red) graphregion(color(white)) legend(size(3.5)   label(1 "Measured") label(2 "Revised") region(lcolor(white)) rows(1)) xtitle("") xlabel(,labsize(4.0))
		graph export Output_Files\Figure_8b.eps, as(eps) replace
		graph export Output_Files\Figure_8b.pdf, as(pdf) replace
		
		preserve
		* For TFP Calculations		
		foreach ftr in "YexH" "N" "K_it" "K_nit" "K_res" "K_u" {
			gen dln_`ftr' = ln(`ftr')-ln(`ftr'[_n-1])
		}
		foreach ftr in "sL_Q" "sK_Q_u" "sK_Q_nit" "sK_Q_it" {
			gen tornq_`ftr' = 0.5*(`ftr'+`ftr'[_n-1])
		}
		gen dln_Tech_exH = growth_true - tornq_sL_Q/(tornq_sL_Q+tornq_sK_Q_it+tornq_sK_Q_nit+tornq_sK_Q_u)*dln_N - tornq_sK_Q_it/(tornq_sL_Q+tornq_sK_Q_it+tornq_sK_Q_nit+tornq_sK_Q_u)*dln_K_it - tornq_sK_Q_nit/(tornq_sL_Q+tornq_sK_Q_it+tornq_sK_Q_nit+tornq_sK_Q_u)*dln_K_nit - tornq_sK_Q_u/(tornq_sL_Q+tornq_sK_Q_it+tornq_sK_Q_nit+tornq_sK_Q_u)*dln_K_u			
		gen decade = "1960-1965" if year>=1960 & year<=1965
		replace decade = "1966-1975" if year>=1966 & year<=1975
		replace decade = "1976-1985" if year>=1976 & year<=1985
		replace decade = "1986-1995" if year>=1986 & year<=1995
		replace decade = "1996-2005" if year>=1996 & year<=2005
		replace decade = "2006-2015" if year>=2006 & year<=2015
		collapse (mean) Case3_TFP=dln_Tech_exH, by(decade)
		save Temp\tfp_case_k, replace					
		restore
							
		keep s_pi_exH year
		duplicates drop
		save Temp\s_pi_casek, replace
	}
	
	if "`case'"=="r_resid" {
		merge 1:1 year using Temp\s_pi_casek, keep(1 3) nogen
		rm Temp\s_pi_casek.dta
		sum s_pi_exH
		replace s_pi_exH = `r(mean)' if missing(s_pi_exH)
		gen r_err = 0
		gen r_effective = r+r_err
		gen residual_pYexHYexH = 1
		gen abs_residual_pYexHYexH = abs(residual_pYexHYexH)
		sum abs_residual_pYexHYexH
		local error = `r(max)'
		
		* Iterate on values for r, until the implied sum of WL+RK leaves a tiny residual (i.e. tiny factorless income)
		while `error' > 1e-6 {
			qui replace r_effective = r+r_err
			foreach ktype in "it" "nit" "res" "gov" {
				qui replace R_`ktype' = (1+taux)/(1-tauk)*xi_`ktype'*(((1+taux[_n-1])*xi_`ktype'[_n-1])/((1+taux)*xi_`ktype')*(1+(1-tauk)*r_effective) - (1-delta_`ktype')-tauk*delta_`ktype'/(1+taux))
				if "`ktype'"=="gov" {
					qui replace R_`ktype' = (1+taux)/(1-tauk)*xi_`ktype'*(((1+taux[_n-1])*xi_`ktype'[_n-1])/((1+taux)*xi_`ktype')*(1+(1-tauk)*0) - (1-delta_`ktype')-tauk*delta_`ktype'/(1+taux))
				}
				qui replace R_`ktype'=0.000001 if R_`ktype'<0
				qui replace sK_`ktype' = (R_`ktype'*K_`ktype')/(pY*Y)
			}
			qui replace residual_pYexHYexH = (pYexHYexH-W*N-R_it*K_it-R_nit*K_nit-R_gov*K_gov-s_pi_exH*pYexHYexH)/pYexHYexH
			qui replace abs_residual_pYexHYexH = abs(residual_pYexHYexH)
			qui replace r_err = r_err+0.1*residual_pYexHYexH
			qui sum abs_residual_pYexHYexH
			local error = `r(max)'
			di "`error'"
		}

		* Calculate factor shares under revised value for r
		gen sL_exH = W*N/(pYexHYexH)
		gen sK_it_exH = R_it*K_it/(pYexHYexH)
		gen sK_nit_exH = R_nit*K_nit/(pYexHYexH)
		foreach ktype in "it" "nit" "res" {	
			gen R_orig_`ktype' = (1+taux)/(1-tauk)*xi_`ktype'*(((1+taux[_n-1])*xi_`ktype'[_n-1])/((1+taux)*xi_`ktype')*(1+(1-tauk)*r) - (1-delta_`ktype')-tauk*delta_`ktype'/(1+taux))
			replace R_orig_`ktype'=0.000001 if R_orig_`ktype'<0
			gen sK_orig_`ktype' = (R_orig_`ktype'*K_`ktype')/(pY*Y)
		}
		gen s_pi_H = (pHH-R_res*K_res)/pHH
		gen s_pi = (pYY-W*N-R_it*K_it-R_nit*K_nit-R_res*K_res-R_gov*K_gov)/pYY
		sort year
		
		foreach var in "r_effective" "R_orig_it" "R_it" "R_orig_nit" "R_nit" "R_orig_res" "R_res" {
			cap gen `var'5 = (`var'[_n-2]+`var'[_n-1]+`var'+`var'[_n+1]+`var'[_n+2])/5
			cap gen `var'3 = (`var'[_n-1]+`var'+`var'[_n+1])/3
			replace `var'3 = `var' if missing(`var'3)
			replace `var'5 = `var'3 if missing(`var'5)
		}

		gen r5_plot = (r[_n-2]+r[_n-1]+r+r[_n+1]+r[_n+2])/5
		gen r3_plot = (r[_n-1]+r+r[_n+1])/3
		replace r3_plot = r if missing(r3_plot)
		replace r5_plot = r3_plot if missing(r5_plot)
		replace r5_plot = r if missing(r5_plot)

		line r5_plot r_effective5 year if year>=1960, ytitle("Percent", height(6) size(4.5)) lp(solid dash) lc(black red) legend(size(3.5)   label(1 "Measured") label(2 "Revised") region(lcolor(white)) rows(1))  xtitle("") xlabel(,labsize(4.0))graphregion(color(white))
		graph export Output_Files\Figure_9a.eps, as(eps) replace
		graph export Output_Files\Figure_9a.pdf, as(pdf) replace		
		line R_orig_it5 R_it5 year if year>=1960, ytitle("Rental Rate", height(6) size(4.5)) lp(solid dash) lc(black red) legend(size(3.5)   label(1 "Measured") label(2 "Revised") region(lcolor(white)) rows(1))  xtitle("") xlabel(,labsize(4.0))graphregion(color(white))
		graph export Output_Files\Figure_9b.eps, as(eps) replace
		graph export Output_Files\Figure_9b.pdf, as(pdf) replace		
		line R_orig_nit5 R_nit5 year if year>=1960, ytitle("Rental Rate", height(6) size(4.5)) lp(solid dash) lc(black red) legend(size(3.5)   label(1 "Measured") label(2 "Revised") region(lcolor(white)) rows(1))  xtitle("") xlabel(,labsize(4.0))graphregion(color(white))
		graph export Output_Files\Figure_9c.eps, as(eps) replace
		graph export Output_Files\Figure_9c.pdf, as(pdf) replace		
		line R_orig_res5 R_res5 year if year>=1960, ytitle("Rental Rate", height(6) size(4.5)) lp(solid dash) lc(black red) legend(size(3.5)   label(1 "Measured") label(2 "Revised") region(lcolor(white)) rows(1))  xtitle("") xlabel(,labsize(4.0))graphregion(color(white))
		graph export Output_Files\Figure_9d.eps, as(eps) replace
		graph export Output_Files\Figure_9d.pdf, as(pdf) replace		
		
		* For TFP Calculations		
		foreach ftr in "Y" "YexH" "N" "K_it" "K_nit" "K_res" "xi_it" "R_it" "R_nit" "R_orig_it" "R_orig_nit" {
			gen dln_`ftr' = ln(`ftr')-ln(`ftr'[_n-1])
		}
		foreach ftr in "sL" "sK_it" "sK_nit" "sK_orig_it" "sK_orig_nit" "sK_res" "sL_exH" "sK_it_exH" "sK_nit_exH" {
			gen tornq_`ftr' = 0.5*(`ftr'+`ftr'[_n-1])
		}
		gen dln_TFP_exH = dln_YexH - (tornq_sL_exH * dln_N) - (1-tornq_sL_exH)* (tornq_sK_it_exH / (tornq_sK_it_exH + tornq_sK_nit_exH)) * dln_K_it - (1-tornq_sL_exH)* (tornq_sK_nit_exH / (tornq_sK_it_exH + tornq_sK_nit_exH)) * dln_K_nit
		gen dln_Tech_exH = dln_YexH - tornq_sL_exH/(tornq_sL_exH+tornq_sK_it_exH+tornq_sK_nit_exH)*dln_N - tornq_sK_it_exH/(tornq_sL_exH+tornq_sK_it_exH+tornq_sK_nit_exH)*dln_K_it - tornq_sK_nit_exH/(tornq_sL_exH+tornq_sK_it_exH+tornq_sK_nit_exH)*dln_K_nit					
		gen decade = "1960-1965" if year>=1960 & year<=1965
		replace decade = "1966-1975" if year>=1966 & year<=1975
		replace decade = "1976-1985" if year>=1976 & year<=1985
		replace decade = "1986-1995" if year>=1986 & year<=1995
		replace decade = "1996-2005" if year>=1996 & year<=2005
		replace decade = "2006-2015" if year>=2006 & year<=2015
		collapse (mean) Case2_TFP=dln_Tech_exH, by(decade)
		merge 1:1 decade using Temp\tfp_case_pi, keep(1 2 3) nogen
		merge 1:1 decade using Temp\tfp_case_k, keep(1 2 3) nogen
		rm Temp\tfp_case_k.dta
		rm Temp\tfp_case_pi.dta
		graph bar Case0_TFP Case1_TFP Case3_TFP Case2_TFP, ytitle("Growth (in logs, annualized)", height(6) size(4.5)) over(decade) graphregion(color(white)) legend(size(3.5)   label(1 "TFP (Naive)") label(2 "Case {&Pi}") label(3 "Case K") label(4 "Case R") region(lcolor(white)) rows(1)) bar(1, color(black)) bar(2, color(red) lwidth(thick) fcolor(white)) bar(3, color(blue) lwidth(thick) fcolor(white)) bar(4, color(green) lwidth(thick) fcolor(white))
		graph export Output_Files\Figure_10.eps, as(eps) replace
		graph export Output_Files\Figure_10.pdf, as(pdf) replace		
	}
}
!rmdir "Temp" /s /q 

